% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc2_mthds.R
\name{SC2_Methods}
\alias{SC2_Methods}
\alias{sc2_mthds}
\title{List of level 2 single-concentration hit-call functions}
\usage{
sc2_mthds()
}
\value{
A list functions
}
\description{
\code{sc2_mthds} returns a list of functions to be used during level 2
single-concentration processing.
}
\details{
The functions contained in the list returned by \code{sc2_mthds} return
a list of expressions to be executed in the \code{sc2} (not exported)
function environment. The functions are described here for reference
purposes, The \code{sc2_mthds} function is not exported, nor is it
intended for use.

All available methods are described in the Available Methods section, listed
by the function/method name.
}
\note{
This function is not exported and is not intended to be used by the user.
}
\section{Available Methods}{


More information about the level 2 single-concentration processing is
available in the package vignette, "Pipeline_Overview."

\describe{
  \item{bmad3}{Add a cutoff value of 3*bmad.}
  \item{pc20}{Add a cutoff value of 20.}
  \item{log2_1.2}{Add a cutoff value of log2(1.2).}
  \item{log10_1.2}{Add a cutoff value of log10(1.2).}
  \item{bmad5}{Add a cutoff value of 5*bmad.}
  \item{bmad6}{Add a cutoff value of 6*bmad.}
  \item{bmad10}{Add a cutoff value of 10*bmad.}
  \item{pc30orbmad3}{Add a cutoff value of either 30 or 3*bmad, whichever
  is less.}
}
}

\seealso{
\code{\link{sc2}}, \code{\link{Method functions}} to query what
methods get applied to each acid
}
\keyword{internal}
