% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoisthNorm.R
\docType{methods}
\name{fitPoisthNorm_sp}
\alias{fitPoisthNorm_sp}
\alias{fitPoisthNorm_sp,matrix-method}
\title{Poisson threshold model based normalization-log2 transformation for multiple slides}
\usage{
fitPoisthNorm_sp(object, ...)

\S4method{fitPoisthNorm_sp}{matrix}(
  object,
  probenum,
  features_high,
  features_all = colnames(object),
  sizefact_start,
  sizefact_BG,
  threshold_mean,
  preci2 = 10000,
  id,
  iterations = 2,
  prior_type = c("contrast", "equal"),
  sizefactrec = TRUE,
  size_scale = c("sum", "first"),
  sizescalebythreshold = FALSE,
  covrob = FALSE,
  preci1con = 1/25,
  cutoff = 15,
  confac = 1
)
}
\arguments{
\item{object}{count matrix with features in rows and samples in columns}

\item{...}{additional argument list that might be used}

\item{probenum}{a vector of numbers of probes in each gene}

\item{features_high}{subset of features which are well above the background}

\item{features_all}{full feature vector to apply the normalization on}

\item{sizefact_start}{initial value for size factors}

\item{sizefact_BG}{size factor for background}

\item{threshold_mean}{average threshold level}

\item{preci2}{precision for threshold, default=10000}

\item{id}{character vector of slide name of each sample}

\item{iterations}{iteration number, default=2,
the first iteration using the features_high to construct the prior for parameters then refit the model on all features.
precision matrix for threshold: preci2}

\item{prior_type}{prior type for preci1, "equal" or "contrast", default="contrast"}

\item{sizefactrec}{XXXX, default = TRUE}

\item{size_scale}{method to scale the sizefact, sum(sizefact)=1 when size_scale="sum", sizefact[1]=1 when size_scale="first"}

\item{sizescalebythreshold}{XXXX, default = FALSE}

\item{covrob}{whether to use robust covariance in calculating the prior precision matrix 1, default = FALSE}

\item{preci1con}{The user input constant term in specifying precision matrix 1, default=1/25}

\item{cutoff}{term in calculating precision matrix 1, default=15}

\item{confac}{The user input factor for contrast in precision matrix 1, default=1}
}
\value{
a list of following items
\itemize{
  \item threshold0, matrix of estimated threshold for iter=1, features in columns and threshold for different slides in rows.
  \item threshold, matrix of estimated threshold for iter=2, features in columns and threshold for different slides in rows.
  \item normmat0, matrix of log2 expression for iter=1, features in columns and log2 expression in rows.
  \item normmat, matrix of log2 expression for iter=2, features in columns and log2 expression in rows.
  \item sizefact, estimated sizefact
  \item sizefact0, estimated sizefact in iter=1
  \item preci1, precision matrix 1
  \item Im0, Information matrix in iter=1
  \item Im, Information matrix in iter=2
  \item conv0, vector of convergence for iter=1, 0 converged, 1 not converged
  \item conv, vector of convergence for iter=2, 0 converged, 1 not converged
  \item features_high, same as the input features_high
  \item features_all, same as the input features_all
}
}
\description{
Poisson threshold model based normalization-log2 transformation for multiple slides
}
