% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBthDE.R
\docType{methods}
\name{DENBth}
\alias{DENBth}
\alias{DENBth,list-method}
\title{Generate DE table using the inference list generated by coefNBth or contrastNBth}
\usage{
DENBth(object, ...)

\S4method{DENBth}{list}(object, variable, NAto1 = TRUE, padj = TRUE, padj_method = "BH")
}
\arguments{
\item{object}{inference list from coefNBth or contrastNBth}

\item{...}{additional argument list that might be used}

\item{variable}{needed to construct}

\item{NAto1}{whether to replace NA in pvalue by 1}

\item{padj}{whether to adjust p value}

\item{padj_method}{p value adjustment method, default="BH"}
}
\value{
DEtab, DE table
}
\description{
Generate DE table using the inference list generated by coefNBth or contrastNBth
}
\examples{
data(NBthmDEmod2)
coeff <- coefNBth(NBthmDEmod2)
DEtab <- DENBth(coeff, variable = "regiontubule")
}
