% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validatedSignatures.R
\name{validatedSignatures}
\alias{validatedSignatures}
\title{Validation result in data frame}
\usage{
validatedSignatures(
  val_all,
  RAVmodel,
  num.out = 5,
  scoreCutoff = NULL,
  swCutoff = NULL,
  clsizeCutoff = NULL,
  indexOnly = FALSE,
  whichPC = NULL,
  filterMessage = TRUE
)
}
\arguments{
\item{val_all}{An output matrix from \code{\link{validate}} function. If this
input is from multiple datasets, only \code{scoreCutoff} argument will be
considered and other inputs will be ignored.}

\item{RAVmodel}{PCAGenomicSignatures-class object. RAVmodel used to prepare
\code{val_all} input.}

\item{num.out}{A number of highly validated RAVs to output. Default is 5.
If any of the cutoff parameters are provided, \code{num.out} or the number of
filtered RAVs, whichever smaller, will be chosen.}

\item{scoreCutoff}{A numeric value for the minimum correlation. For
multi-studies case, the default is 0.7.}

\item{swCutoff}{A numeric value for the minimum average silhouette width.}

\item{clsizeCutoff}{An integer value for the minimum cluster size.}

\item{indexOnly}{A logical. Under the default (= \code{FALSE}), the detailed
information on validated RAVs, such as score, average silhouette width,
cluster size, is printed. If it is set TRUE, only the RAV number will be
printed.}

\item{whichPC}{An integer value between 1 and 8. PC number of your data to
check the validated signatures with. Under the default (\code{NULL}), it
outputs top scored signatures with any PC of your data.}

\item{filterMessage}{A logical. Under the default \code{TRUE}, any output
RAV belong to the filtering list will give a message. Silence this message
with \code{filterMessage=FALSE}. You can check the filter list using
\code{data("filterList")}.}
}
\value{
A subset of the input matrix, which meets the given condition.
}
\description{
Validation result in data frame
}
\examples{
data(miniRAVmodel)
library(bcellViper)
data(bcellViper)
val_all <- validate(dset, miniRAVmodel)
validatedSignatures(val_all, miniRAVmodel, num.out = 3, scoreCutoff = 0)

}
