% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{.loadingCor}
\alias{.loadingCor}
\title{Validating new dataset}
\usage{
.loadingCor(dataset, avgLoading, n = n, method = method, scale = FALSE)
}
\arguments{
\item{dataset}{A gene expression profile to be validated. Different classes
of objects can be used including ExpressionSet, SummarizedExperiment,
RangedSummarizedExperiment, or matrix. Rownames (genes) should be in 
human gene symbol format (HGNC). If dataset is a matrix, genes should be in 
rows and samples in columns. RNA-seq counts should be log(count + 1) 
prior to the `validate()` call.}

\item{avgLoading}{A matrix with genes by RAVs.}

\item{n}{A integer. The number of PCs to use for validation. It should be
equal or less then the number of samples in the input dataset.}

\item{method}{A character string indicating which correlation coefficient is
to be computed. One of "pearson" (default), "kendall", or "spearman": can be
abbreviated.}

\item{scale}{Default is \code{FALSE}. If it is set to \code{TRUE}, rows 
will be converted to z-score prior to PCA.}
}
\value{
A matrix of Pearson correlation coefficient (default, defined through
\code{method} argument) between RAVs (row) and the top 8 PCs from the
datasets (column)
}
\description{
Validating new dataset
}
\keyword{internal}
