% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAGenomicSignatures-methods.R
\name{PCAGenomicSignatures}
\alias{PCAGenomicSignatures}
\title{Construct \code{PCAGenomicSignatures} object}
\usage{
PCAGenomicSignatures(..., trainingData)
}
\arguments{
\item{...}{Additional arguments for supporting functions.}

\item{trainingData}{A \code{\link[S4Vectors]{DataFrame}} class object for
metadata associated with training data}
}
\value{
PCAGenomicSignatures object with multiple setters or accessors
}
\description{
The default contents of \code{PCAGenomicSignatures} object, with
a set of accessors and setter generic functions, which extract either the
\code{assay}, \code{colData}, \code{metadata}, or \code{trainingData} slots
of a \code{\link{PCAGenomicSignatures-class}} object. When you create this
object, \code{colData$studies} should be populated before adding any
information in \code{trainingData} slot
}
\details{
\itemize{
    \item RAVindex(x) : RAVindex (= avgLoadings) containing genes x RAVs
    \item metadata(x)$cluster : A vector of integers (from 1:k) indicating
    the cluster to which each point is allocated.
    \item metadata(x)$size : The number of PCs in each cluster.
    \item metadata(x)$k : The number of RAVs.
    \item metadata(x)$n : The number of top PCs from each dataset.
    \item metadata(x)$geneSets : Name of the prior gene sets used to annotate
    average loadings.
    \item colData(x)$studies : A list of character vectors containing studies
    contributing to each PC cluster.
    \item colData(x)$silhouetteWidth : A numeric array of average silhouette
    widths of each clusters
    \item colData(x)$gsea : A list of data frames. Each element is a subset
    of outputs from \code{clusterProfiler::GSEA} function.
}
}
\section{Slots}{

\describe{
\item{\code{trainingData}}{A \code{\link[S4Vectors]{DataFrame}} class object for
metadata associated with training data}
}}

\section{Setters}{

Setter method values (i.e., \code{function(x) <- value}):
\itemize{
    \item geneSets<- : A character vector containing the name of gene sets
    used to annotate average loadings
    \item studies<- : A list of character vectors containing gene sets used
    to annotate average loadings
    \item gsea<- : A list of data frames. Each element is a subset of output
    from \code{gseaResult} objects.
    \item metadata<- : A \code{list} object of metadata
    \item `$<-` : A vector to replace the indicated column in \code{colData}
}
}

\section{Accessors}{

All the accessors inherited from \code{SummarizedExperiment} are available
and the additional accessors for \code{PCAGenomicSignatures} specific data
are listed below.
\itemize{
   \item RAVindex : Equivalent to the \code{assay(x)}
   \item geneSets : Access the \code{metadata(x)$geneSets} slot
   \item studies : Access the \code{colData(x)$studies} slot
   \item gsea : Access the \code{colData(x)$gsea}
   \item `$` : Access a column in \code{colData}
   \item trainingData : Access the \code{trainingData} slot
   \item mesh : Access the \code{trainingData(x)$MeSH} slot
   \item PCAsummary : Access the \code{trainingData(x)$PCAsummary} slot
}
}

\examples{
data(miniRAVmodel)
miniRAVmodel

}
