% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_bam_correlation.R
\name{plot_bam_correlation}
\alias{plot_bam_correlation}
\title{Plot correlation of bam files}
\usage{
plot_bam_correlation(
  bamFiles,
  binSize = 1e+06,
  outPrefix = NULL,
  importParams = NULL,
  grouping = NULL,
  verbose = FALSE,
  hw = c(8, 8),
  nc = 2
)
}
\arguments{
\item{bamFiles}{a named vector of strings denoting file names}

\item{binSize}{an integer denoting the tile width for tiling the genome, default 1000000}

\item{outPrefix}{a string denoting output file name in pdf format}

\item{importParams}{a list of parameters for \code{handle_input}}

\item{grouping}{a named vector for bamFiles group assignment}

\item{verbose}{logical, indicating whether to output additional information}

\item{hw}{a vector of two elements specifying the height and width of the output figures}

\item{nc}{integer, number of cores for parallel processing}
}
\value{
a dataframe of read counts per bin per sample
}
\description{
Plot correlation in reads coverage distributions along the genome for bam files. Generates a fingerprint plot, a heatmap of correlation coefficients with hierarchical clustering, a pairwise correlation plot and a PCA plot.
}
\examples{

bamQueryFiles <- c(
    system.file("extdata", "chip_input_chr19.bam", package = "GenomicPlot"),
    system.file("extdata", "chip_treat_chr19.bam", package = "GenomicPlot")
)
grouping <- c(1, 2)
names(bamQueryFiles) <- names(grouping) <- c("chip_input", "chip_treat")

bamImportParams <- setImportParams(
    offset = 0, fix_width = 150, fix_point = "start", norm = FALSE,
    useScore = FALSE, outRle = FALSE, useSizeFactor = FALSE, genome = "hg19"
)

plot_bam_correlation(
    bamFiles = bamQueryFiles, binSize = 100000, outPrefix = NULL,
    importParams = bamImportParams, nc = 2, verbose = FALSE
)

}
