% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandleFeatures.R
\name{filter_by_overlaps_stranded}
\alias{filter_by_overlaps_stranded}
\title{Filter GRanges by overlaps in a stranded way}
\usage{
filter_by_overlaps_stranded(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  ignore.order = TRUE
)
}
\arguments{
\item{query}{a GRanges object}

\item{subject}{a GRanges object}

\item{maxgap}{an integer denoting the distance that define overlap}

\item{minoverlap}{The minimum amount of overlap between intervals as a
single integer greater than 0. If you modify this argument, maxgap must be
held fixed.}

\item{ignore.order}{logical, indicating whether the order of query and
subject can be switched, default = TRUE. Overlaps in query and subject often
have different sizes. This parameter will make the function use whichever is
smaller to avoid errors when making Venn diagrams.}
}
\value{
a GRanges object
}
\description{
This function reports all query GRanges that have overlaps in
subject GRanges. Strand information is used to define overlap.
}
\examples{

query <- GRanges("chr19",
    IRanges(rep(c(10, 15), 2), width = c(1, 20, 40, 50)),
    strand = c("+", "+", "-", "-")
)

subject <- GRanges("chr19",
    IRanges(rep(c(13, 150), 2), width = c(10, 14, 20, 28)),
    strand = c("+", "-", "-", "+")
)

res <- filter_by_overlaps_stranded(query, subject)
res
resf <- filter_by_overlaps_stranded(query, subject, ignore.order = FALSE)
resf

}
\author{
Shuye Pu
}
