% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawingFunctions.R
\name{draw_locus_profile}
\alias{draw_locus_profile}
\title{Plot signal profile around genomic loci}
\usage{
draw_locus_profile(
  plot_df,
  xc = "Position",
  yc = "Intensity",
  cn = "Query",
  sn = NULL,
  Xlab = "Center",
  Ylab = "Signal Intensity",
  shade = FALSE,
  hl = c(0, 0)
)
}
\arguments{
\item{plot_df}{a dataframe with column names c(xc, yc, cn, "lower", "upper")}

\item{xc}{a string denoting column name for values on x-axis}

\item{yc}{a string denoting column name for numeric data to be plotted}

\item{cn}{a string denoting column name for sample grouping, like 'Query' or
'Reference'}

\item{sn}{a string denoting column name for the subject of sample grouping,
if 'cn' is 'Query', then 'sn' will be 'Reference'}

\item{Xlab}{a string for x-axis label}

\item{Ylab}{a string for y-axis label}

\item{shade}{logical indicating whether to place a shaded rectangle
around the loci bounded by hl}

\item{hl}{a vector of two integers defining upstream and downstream
boundaries of the rectangle}
}
\value{
a ggplot object
}
\description{
Plot lines with standard error as the error band
}
\note{
used by \code{\link{plot_locus}}, \code{\link{plot_locus_with_random}}
}
\examples{
library(dplyr)
Reference <- rep(rep(c("Ref1", "Ref2"), each = 100), 2)
Query <- rep(c("Query1", "Query2"), each = 200)
Position <- rep(seq(-50, 49), 4)
Intensity <- rlnorm(400)
se <- runif(400)
df <- data.frame(Intensity, se, Position, Query, Reference) \%>\%
    mutate(lower = Intensity - se, upper = Intensity + se) \%>\%
    mutate(Group = paste(Query, Reference, sep = ":"))

p <- draw_locus_profile(df, cn = "Group", shade = TRUE, hl = c(-10, 20))
p

}
\author{
Shuye Pu
}
