% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewPoints.R
\name{viewPoint}
\alias{viewPoint}
\title{Virtual 4C viewpoint}
\usage{
viewPoint(x, bait, region = NULL, ...)
}
\arguments{
\item{x}{A GInteractions object.}

\item{bait}{A GRanges object describing bait regions.}

\item{region}{If present, a GRanges object specifying the
region to look for bait interactions in.}

\item{...}{additional arguments to findoverlaps}
}
\value{
A GInteractions object.
}
\description{
This function creates a GInteractions object representing interactions 
originating at a given viewpoint ('bait'), or set of viewpoints. This is 
similar to the idea of a virtual 4C experiment where you are interested in 
interactions with a specific region.
}
\details{
The object returned has the 'bait' as anchor one, and the interacting regions 
as anchor two. By default this is genome wide. If you only want to consider 
interactions within a certain distance around the bait, you can specify a 
region to consider.

Multiple baits can be given, e.g. to find all interactions around promoters.

You may want to visualise the resulting interactions in a genome browser - 
you can do this by creating coverage over anchor two of the object and exporting 
as a wig or bedgraph file.
}
\examples{
data(hic_example_data)
library(GenomicRanges)
pos <- GRanges(seqnames='chr15', ranges=IRanges(start=59477709, end=59482708))
region <- GRanges(seqnames='chr15', ranges=IRanges(start=58980209, end=59980208))
vp <- viewPoint(hic_example_data, pos, region)
}
