% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{setters}
\alias{setters}
\alias{name<-}
\alias{interactionCounts<-}
\alias{name<-,GInteractions-method}
\alias{description<-,GInteractions,ANY-method}
\alias{interactionCounts<-,GInteractions-method}
\title{Functions to set data held in a GInteractions object.}
\usage{
name(GIObject) <- value

interactionCounts(GIObject) <- value

\S4method{name}{GInteractions}(GIObject) <- value

\S4method{description}{GInteractions,ANY}(object) <- value

\S4method{interactionCounts}{GInteractions}(GIObject) <- value
}
\arguments{
\item{GIObject}{A GenomicInteractions object}

\item{value}{A vector to replace a slot in the object}

\item{object}{Object, possibly derived from class \code{\link[Biobase]{eSet-class}}.}
}
\value{
GenomicInteractions object
}
\description{
Use these functions to set data stored in each of the slots of a
GInteractions object.
}
\examples{

library(GenomicRanges)

anchor.one = GRanges(c('chr1', 'chr1', 'chr1', 'chr1'), IRanges(c(10, 20, 30, 20), width=5))
anchor.two = GRanges(c('chr1', 'chr1', 'chr1', 'chr2'), IRanges(c(100, 200, 300, 50), width=5))
interaction_counts = sample(1:10, 4)
test <- GenomicInteractions(anchor.one, anchor.two, experiment_name='test', 
                           description='this is a test', counts=interaction_counts)

name(test) <- 'Mouse test'
name(test)

description(test) <- 'This is a test using the mouse genome'
description(test)

interactionCounts(test) <- c(2,3,8,5)
interactionCounts(test)

}
