% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\docType{methods}
\name{export.bed12}
\alias{export.bed12}
\alias{export.bed12,GInteractions-method}
\title{Export interactions in BED12 format.}
\usage{
export.bed12(GIObject, fn = NULL, score = "counts")

\S4method{export.bed12}{GInteractions}(GIObject, fn = NULL, score = "counts")
}
\arguments{
\item{GIObject}{A GInteractions object.}

\item{fn}{A filename to write the object to}

\item{score}{Which metadata column to export as score

Exports a GInteractions object to BED12 format, and writes to a specified file. If filename is not specified,
then a data.frame containing the information is returned.

Bed12 files provide a method for visualising interactions, it is not a good format for storing all of the data associated
with an interaction dataset, particularly for trans-chromosomal interactions, which can only be stored in the bed12 names
field.}
}
\value{
invisible(1) if outputting to file or a data.frame containing all of the corresponding information
}
\description{
Export interactions in BED12 format.
}
\examples{
data(hic_example_data)
export.bed12(hic_example_data, fn = tempfile(), score = 'counts')
}
