% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetting.R
\docType{methods}
\name{subsetByFeatures}
\alias{subsetByFeatures}
\alias{subsetByFeatures,GInteractions,GRanges,missing-method}
\alias{subsetByFeatures,GInteractions,GRangesList,missing-method}
\alias{subsetByFeatures,GInteractions,character,character-method}
\title{Subset a GInteractions object by features}
\usage{
subsetByFeatures(GIObject, features, feature.class = NULL)

\S4method{subsetByFeatures}{GInteractions,GRanges,missing}(GIObject, features, feature.class = NULL)

\S4method{subsetByFeatures}{GInteractions,GRangesList,missing}(GIObject, features, feature.class = NULL)

\S4method{subsetByFeatures}{GInteractions,character,character}(GIObject, features, feature.class = NULL)
}
\arguments{
\item{GIObject}{A GInteractions object}

\item{features}{A GRanges or GRangesList object, or a character vector
containing IDs of annotated features, e.g. promoter IDs.}

\item{feature.class}{If `features' is a character vector, the corresponding
feature name, e.g. 'promoter'.}
}
\value{
a subsetted GInteractions object
}
\description{
Subsets interactions for which at least one of the anchors overlaps with a
given GRanges object. Alternatively, subsets interactions based on annotated
feature IDs for a particular feature.
}
\examples{
data('hic_example_data')
data('mm9_refseq_promoters')
ids <- names(mm9_refseq_promoters[1:10])
subsetByFeatures(hic_example_data, ids, 'promoter')
}
