% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRandomNodes.R
\name{createRandomNodes}
\alias{createRandomNodes}
\title{Create a list of random nodes}
\usage{
createRandomNodes(
  txdb,
  seq = "chr22",
  size = 500,
  upstream = 500,
  downstream = 500,
  maxDist = 1e+06,
  wid = 5000
)
}
\arguments{
\item{txdb}{An TxDb object.}

\item{seq}{seqlevels to be kept.}

\item{size}{the length of regions involved in nodes}

\item{upstream, downstream}{upstream or downstream for promoters}

\item{maxDist}{maximal distance from promoters}

\item{wid}{regions width.}
}
\value{
An GRanges object with comp_id metadata.
}
\description{
Generate a list of random nodes used for example or test.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
set.seed(123)
node_regions <- createRandomNodes(TxDb.Hsapiens.UCSC.hg19.knownGene)
}
