% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition-plots.R
\name{plotExpectedPartitions}
\alias{plotExpectedPartitions}
\title{Produces a barplot showing how query regions of interest are distributed
relative to the expected distribution across a given partition list}
\usage{
plotExpectedPartitions(expectedPartitions, feature_names = NULL, pval = FALSE)
}
\arguments{
\item{expectedPartitions}{A data.frame holding the frequency of assignment
to each of the partitions, the expected number of each partition, and
the log10 of the observed over expected. Produced by
\code{calcExpectedPartitions}.}

\item{feature_names}{Character vector with labels for the partitions
(optional). By default it will use the names from the first argument.}

\item{pval}{Logical indicating whether Chi-square p-values should be added
for each partition.}
}
\value{
A ggplot object using a barplot to show the distribution of the
    query regions across a given partition list.
}
\description{
Produces a barplot showing how query regions of interest are distributed
relative to the expected distribution across a given partition list
}
\examples{
p = calcExpectedPartitionsRef(vistaEnhancers, "hg19")
expectedPlot = plotExpectedPartitions(p)
}
