% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildReferenceData.R
\name{getTssFromGTF}
\alias{getTssFromGTF}
\title{Get transcription start sites (TSSs) from a remote or local GTF file}
\usage{
getTssFromGTF(
  source,
  convertEnsemblUCSC = FALSE,
  destDir = NULL,
  filterProteinCoding = TRUE
)
}
\arguments{
\item{source}{a string that is either a path to a local or remote GTF}

\item{convertEnsemblUCSC}{a logical indicating whether Ensembl style 
chromosome annotation should be changed to UCSC style}

\item{destDir}{a string that indicates the path to the directory where 
the downloaded GTF file should be stored}

\item{filterProteinCoding}{a logical indicating if TSSs should be only
protein-coding genes (default = TRUE)}
}
\value{
a list of GRanges objects
}
\description{
Get transcription start sites (TSSs) from a remote or local GTF file
}
\examples{
CElegansGtfCropped = system.file("extdata", 
                                 "C_elegans_cropped_example.gtf.gz", 
                                 package="GenomicDistributions")
CElegansTss = getTssFromGTF(CElegansGtfCropped, TRUE)
}
