% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildReferenceData.R
\name{getGeneModelsFromGTF}
\alias{getGeneModelsFromGTF}
\title{Get gene models from a remote or local GTF file}
\usage{
getGeneModelsFromGTF(
  source,
  features,
  convertEnsemblUCSC = FALSE,
  destDir = NULL,
  filterProteinCoding = TRUE
)
}
\arguments{
\item{source}{a string that is either a path to a local or remote GTF}

\item{features}{a vector of strings with feature identifiers that to 
include in the result list}

\item{convertEnsemblUCSC}{a logical indicating whether Ensembl style 
chromosome annotation should be changed to UCSC style}

\item{destDir}{a string that indicates the path to the directory where
the downloaded GTF file should be stored}

\item{filterProteinCoding}{a logical indicating if TSSs should be only
protein-coding genes (default = TRUE)}
}
\value{
a list of GRanges objects
}
\description{
Get gene models from a remote or local GTF file
}
\examples{
CElegansGtfCropped = system.file("extdata", 
                                 "C_elegans_cropped_example.gtf.gz", 
                                 package="GenomicDistributions")
features = c("gene", "exon", "three_prime_utr", "five_prime_utr")
CElegansGeneModels = getGeneModelsFromGTF(CElegansGtfCropped, features, TRUE)
}
