% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{dtToGr}
\alias{dtToGr}
\title{Converts a data.table (DT) object to a GenomicRanges 
(GR) object. Tries to be intelligent, guessing chr 
and start, but you have to supply end or other
columns if you want them to be carried into the GR.}
\usage{
dtToGr(
  DT,
  chr = "chr",
  start = "start",
  end = NA,
  strand = NA,
  name = NA,
  splitFactor = NA,
  metaCols = NA
)
}
\arguments{
\item{DT}{A data.table representing genomic regions.}

\item{chr}{A string representing the chromosome column.}

\item{start}{A string representing the name of the start column.}

\item{end}{A string representing the name of the end column.}

\item{strand}{A string representing the name of the strand column.}

\item{name}{A string representing the name of the name column.}

\item{splitFactor}{A string representing the name of the column to use to
split the data.table into multiple data.tables.}

\item{metaCols}{A string representing the name of the metadata column(s)
to include in the returned GRanges object.}
}
\value{
A GRanges object.
}
\description{
Converts a data.table (DT) object to a GenomicRanges 
(GR) object. Tries to be intelligent, guessing chr 
and start, but you have to supply end or other
columns if you want them to be carried into the GR.
}
\examples{
start1 = c(seq(from=1, to = 2001, by = 1000), 800)
chrString1 = c(rep("chr1", 3), "chr2")
dt = data.table::data.table(chr=chrString1,
                            start=start1,
                            end=start1 + 250)
newGR = dtToGr(dt)                
}
