% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature-plots.R
\name{calcFeatureDist}
\alias{calcFeatureDist}
\title{Find the distance to the nearest genomic feature}
\usage{
calcFeatureDist(query, features)
}
\arguments{
\item{query}{A GRanges or GRangesList object with query sets}

\item{features}{A GRanges object with features to test distance to}
}
\value{
A vector of genomic distances for each query region relative to its 
    closest feature.
}
\description{
For a given query set of genomic regions, and a given feature set of 
regions, this function will return the distance for each query region to its
closest feature. It ignores strand and returns the distance as positive or 
negative, depending on whether the feature is upstream or downstream
}
\details{
This function is similar to the bioconductor distanceToNearest function, but
returns negative values for downstream distances instead of absolute values.
This allows you to assess the relative location.
}
\examples{
vistaSftd = GenomicRanges::shift(vistaEnhancers, 100000)
calcFeatureDist(vistaEnhancers, vistaSftd) 
}
