% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrom-plots.R
\name{binBSGenome}
\alias{binBSGenome}
\title{Bins a BSgenome object.}
\usage{
binBSGenome(genome, binCount)
}
\arguments{
\item{genome}{A UCSC-style string denoting reference assembly (e.g. 'hg38')}

\item{binCount}{number of bins per chromosome}
}
\value{
A data.table object showing the region and bin IDs 
        of the reference genome.
}
\description{
Given a BSgenome object (to be loaded via \code{loadBSgenome}), and a number
of bins, this will bin that genome. It is a simple wrapper of the
\code{binChroms} function
}
\examples{
\dontrun{
binCount = 1000
refGenomeBins = binBSGenome("hg19", binCount)
}
}
