% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifest.R
\name{write_manifest}
\alias{write_manifest}
\title{write a manifest data.frame to disk}
\usage{
write_manifest(manifest, destfile = tempfile())
}
\arguments{
\item{manifest}{A data.frame with five columns, typically
created by a call to \code{\link{manifest}}}

\item{destfile}{The filename for saving the manifest.}
}
\value{
character(1) the destination file name.
}
\description{
The \code{\link{manifest}} method creates a data.frame
that represents the data for a manifest file needed
by the GDC Data Transfer Tool. While the file format
is nothing special, this is a simple helper function
to write a manifest data.frame to disk. It returns
the path to which the file is written, so it can
be used "in-line" in a call to \code{\link{transfer}}.
}
\examples{
mf = files() |> manifest(size=10)
write_manifest(mf)

}
