% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query}
\alias{query}
\alias{GDCQuery}
\alias{cases}
\alias{files}
\alias{projects}
\alias{annotations}
\alias{ssms}
\alias{ssm_occurrences}
\alias{cnvs}
\alias{cnv_occurrences}
\alias{genes}
\title{Start a query of GDC metadata}
\usage{
query(
  entity,
  filters = NULL,
  facets = NULL,
  expand = NULL,
  fields = default_fields(entity),
  ...
)

cases(...)

files(...)

projects(...)

annotations(...)

ssms(...)

ssm_occurrences(...)

cnvs(...)

cnv_occurrences(...)

genes(...)
}
\arguments{
\item{entity}{character vector, including one of the entities in .gdc_entities}

\item{filters}{a filter list, typically created using \code{\link{make_filter}}, or added
to an existing \code{GDCQuery} object using \code{\link{filter}}.}

\item{facets}{a character vector of facets for counting common values. 
See \code{\link{available_fields}}. In general, one will not specify this parameter
but will use \code{\link{facet}} instead.}

\item{expand}{a character vector of "expands" to include in returned data. See 
\code{\link{available_expand}}}

\item{fields}{a character vector of fields to return. See \code{\link{available_fields}}.
In general, one will not specify fields directly, but instead use \code{\link{select}}}

\item{...}{passed through to \code{\link{query}}}
}
\value{
An S3 object, the GDCQuery object. This is a list
with the following members.
\itemize{
\item{filters}
\item{facets}
\item{fields}
\item{expand}
\item{archive}
\item{token}
}
}
\description{
The basis for all functionality in this package
starts with constructing a query in R. The GDCQuery
object contains the filters, facets, and other
parameters that define the returned results. A token
is required for accessing certain datasets.
}
\section{Functions}{
\itemize{
\item \code{cases()}: convenience constructor for a GDCQuery for cases

\item \code{files()}: convenience contructor for a GDCQuery for files

\item \code{projects()}: convenience contructor for a GDCQuery for projects

\item \code{annotations()}: convenience contructor for a GDCQuery for annotations

\item \code{ssms()}: convenience contructor for a GDCQuery for ssms

\item \code{ssm_occurrences()}: convenience contructor for a GDCQuery for ssm_occurrences

\item \code{cnvs()}: convenience contructor for a GDCQuery for cnvs

\item \code{cnv_occurrences()}: convenience contructor for a GDCQuery for cnv_occurrences

\item \code{genes()}: convenience contructor for a GDCQuery for genes

}}
\examples{
qcases = query('cases')
# equivalent to:
qcases = cases()

}
