% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical.R
\name{gdc_clinical}
\alias{gdc_clinical}
\title{Get clinical information from GDC}
\usage{
gdc_clinical(case_ids, include_list_cols = FALSE)
}
\arguments{
\item{case_ids}{a character() vector of case_ids, typically from
"cases" query.}

\item{include_list_cols}{logical(1), whether to include list
columns in the "main" data.frame. These list columns have
values for aliquots, samples, etc. While these may be useful
for some situations, they are generally not that useful as
clinical annotations.}
}
\value{
A list of four data.frames:
\enumerate{
\item main, representing basic case identification and metadata
    (update date, etc.)
\item diagnoses
\item esposures
\item demographic
}
}
\description{
The NCI GDC has a complex data model that allows various studies to
supply numerous clinical and demographic data elements. However,
across all projects that enter the GDC, there are
similarities. This function returns four data.frames associated
with case_ids from the GDC.
}
\details{
Note that these data.frames can, in general, have different numbers
of rows (or even no rows at all). If one wishes to combine to
produce a single data.frame, using the approach of left joining to
the "main" data.frame will yield a useful combined data.frame. We
do not do that directly given the potential for 1:many
relationships. It is up to the user to determine what the best
approach is for any given dataset.
}
\examples{
case_ids = cases() |> results(size=10) |> ids()
clinical_data = gdc_clinical(case_ids)

# overview of clinical results
class(clinical_data)
names(clinical_data)
sapply(clinical_data, class)
sapply(clinical_data, nrow)

# available data
head(clinical_data$main)
head(clinical_data$demographic)
head(clinical_data$diagnoses)
head(clinical_data$exposures)

}
