% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk_transfer.R
\name{gdc_client}
\alias{gdc_client}
\title{return gdc-client executable path}
\usage{
gdc_client()
}
\value{
character(1) the path to the gdc-client executable.
}
\description{
This function is a convenience function to 
find and return the path to the GDC Data Transfer
Tool executable assumed to be named 'gdc-client'. 
The assumption is that the appropriate version of the
GDC Data Transfer Tool is a separate download available
from \href{the GDC website}{https://gdc.cancer.gov/access-data/gdc-data-transfer-tool}
and as a backup from \href{on github}{https://github.com/NCI-GDC/gdc-client}.
}
\details{
The path is checked in the following order:
\enumerate{
\item an R option("gdc_client")
\item an environment variable GDC_CLIENT
\item from the search PATH
\item in the current working directory
}
}
\examples{
# this cannot run without first
# downloading the GDC Data Transfer Tool
gdc_client = try(gdc_client(),silent=TRUE)

}
