% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{available_expand}
\alias{available_expand}
\alias{available_expand.character}
\alias{available_expand.GDCQuery}
\title{Return valid values for "expand"}
\usage{
available_expand(entity)

\method{available_expand}{character}(entity)

\method{available_expand}{GDCQuery}(entity)
}
\arguments{
\item{entity}{Either a \code{\link{GDCQuery}} object
or a character(1) specifying a GDC entity ('cases', 'files',
'annotations', 'projects')}
}
\value{
A character vector
}
\description{
The GDC allows a shorthand for specifying groups
of fields to be returned by the metadata queries.
These can be specified in a \code{\link{select}}
method call to easily supply groups of fields.
}
\examples{
head(available_expand('files'))

}
\seealso{
See \url{https://docs.gdc.cancer.gov/API/Users_Guide/Search_and_Retrieval/#expand}
for details
}
