% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translation.R
\name{translation}
\alias{translation}
\alias{translation,character-method}
\alias{translation,BioString-method}
\title{Translation of DNA/RNA sequences}
\usage{
translation(x, ...)

\S4method{translation}{character}(
  x,
  genetic.code = getGeneticCode("1"),
  no.init.codon = FALSE,
  if.fuzzy.codon = "error"
)

\S4method{translation}{BioString}(
  x,
  genetic.code = getGeneticCode("1"),
  no.init.codon = FALSE,
  if.fuzzy.codon = "error"
)
}
\arguments{
\item{x}{A character string or the same arguments given to function
\code{\link[Biostrings]{translate}}.}

\item{...}{Not in use yet.}

\item{genetic.code}{The same as in \code{\link[Biostrings]{translate}}}

\item{no.init.codon, if.fuzzy.codon}{Used only if 'x' is not a 'character'
object. The same as in \code{\link[Biostrings]{translate}}.}
}
\value{
The translated amino acid sequence.
}
\description{
This function extends \code{\link[Biostrings]{translate}}
function to include letters that are frequently found in the DNA sequence
databases to indicate missing information and are not part of the the
DNA/RNA alphabet. Also, it is able to process sequences as just simple
'character' objects.
}
\details{
If argument 'x' belong to any of the classes admitted by function
\code{\link[Biostrings]{translate}}, then this function is called to make
the translation.
}
\examples{
## Load a small DNA sequence alingment 
data("aln", package = "GenomAutomorphism")

translation(aln)

## Load a pairwise DNA sequence alingment of COVID-19 genomes
data("covid_aln", package = "GenomAutomorphism")

translation(covid_aln)
}
\seealso{
\code{\link[Biostrings]{translate}}
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
