% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slapply.R
\name{slapply}
\alias{slapply}
\title{Apply a function over a list-like object preserving its attributes}
\usage{
slapply(
  x,
  FUN,
  keep.attr = FALSE,
  class = NULL,
  simplify = TRUE,
  USE.NAMES = TRUE,
  ...
)
}
\arguments{
\item{x}{A list-like or vector-like object.}

\item{FUN, ...}{The same as described in \code{\link[base]{lapply}}.}

\item{keep.attr}{Logic. If TRUE, then the original attributes from 'x' are
preserved in the returned list. Default is FALSE.}

\item{class}{Name of the class to which the returned list belongs to.
Default is NULL.}

\item{simplify, USE.NAMES}{The same as described in
\code{\link[base]{sapply}}.}
}
\value{
Same as in ?base::\code{\link[base]{lapply}} if keep.attr = FALSE.
Otherwise same values preserving original attributes from 'x'.
}
\description{
This function apply a function over a list-like object
preserving its attributes and simplify (if requested) the list as
\code{\link[base]{sapply}} function does. \strong{slapply} returns a
list of the same length as 'x', each element of which is the result of
applying FUN to the corresponding element of 'x'.
}
\examples{
## Create a list
x <- list(a = seq(10), beta = exp(seq(-3, 3)), 
          logic = c(TRUE, FALSE, FALSE, TRUE))
class(x) <- "nice"

## To compute the list mean for each list element using 'base::lapply'
class(slapply(x, mean, simplify = FALSE))

## Simply 'base::lapply' preserving attributes
slapply(x, mean, keep.attr = TRUE, simplify = FALSE)

## To preserve attributes and simplify
slapply(x, mean, keep.attr = TRUE, simplify = TRUE)

}
\seealso{
\code{\link[base]{lapply}} and \code{\link[base]{sapply}}
}
\author{
Robersy Sanchez (\url{https://genomaths.com}).
}
