% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqranges.R
\name{seqranges}
\alias{seqranges}
\alias{seqranges,CodonSeq-method}
\alias{seqranges,DNAStringSet_OR_NULL-method}
\title{Get DNA sequence Ranges and Coordinates representation on a given
Abelian Group}
\usage{
seqranges(x, ...)

\S4method{seqranges}{CodonSeq}(x, granges = TRUE)

\S4method{seqranges}{DNAStringSet_OR_NULL}(
  x,
  granges = TRUE,
  base_seq = TRUE,
  filepath = NULL,
  start = NA,
  end = NA,
  chr = 1L,
  strand = "+"
)
}
\arguments{
\item{x}{An object from a \code{\link[Biostrings]{DNAStringSet}} or
\code{\link[Biostrings]{DNAMultipleAlignment}} class carrying the DNA
pairwise alignment of two sequences.}

\item{...}{Not in use.}

\item{granges}{Logical. Whether to return a
\code{\link[GenomicRanges]{GRanges-class}} object or a
\code{\link[S4Vectors]{DataFrame}}.}

\item{base_seq}{Logical. Whether to return the base or codon coordinates on
the selected Abelian group. If codon coordinates are requested, then the
number of the DNA bases in the given sequences must be multiple of 3.}

\item{filepath}{A character vector containing the path to a file in
\emph{\strong{fasta}} format to be read. This argument must be given if
\emph{codon & base} arguments are not provided.}

\item{start, end, chr, strand}{Optional parameters required to build a
\code{\link[GenomicRanges]{GRanges-class}}. If not provided the default
values given for the function definition will be used.}
}
\value{
A \code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Extract the gene ranges and coordinates from a pairwise
alignment of codon/base sequences represented on a given Abelian group.
}
\details{
This function provide an alternative way to get the codon
coordinate and the information on the codon sequence from a
\code{\link{CodonSeq}} class objects. The function can either take the
output from functions \code{\link{codon_coord}} or to operate directly on a
\code{\link[Biostrings]{DNAStringSet}} or to retrieve the a DNA sequence
alignment from a file.
}
\examples{
## Load a pairwise alignment
data("aln", package = "GenomAutomorphism")
aln

## A GRanges object carrying the aligned DNA sequence.
seqranges(
    x = aln,
    base_seq = TRUE,
    filepath = NULL,
)

## A GRanges object carrying the aligned codon sequence.
seqranges(
    x = aln,
    base_seq = FALSE,
    filepath = NULL,
)
}
\references{
\enumerate{
\item Robersy Sanchez, Jesus Barreto (2021) Genomic Abelian Finite
Groups.
\href{https://doi.org/10.1101/2021.06.01.446543}{doi:10.1101/2021.06.01.446543}
\item M. V Jose, E.R. Morgado, R. Sanchez, T. Govezensky, The 24 possible
algebraic representations of the standard genetic code in six or in three
dimensions, Adv. Stud. Biol. 4 (2012) 119-152.\href{https://is.gd/na9eap}{PDF}.
\item R. Sanchez. Symmetric Group of the Genetic-Code Cubes. Effect of the
Genetic-Code Architecture on the Evolutionary Process MATCH Commun. Math.
Comput. Chem. 79 (2018) 527-560.
}
}
\seealso{
\code{\link{matrices}}, \code{\link{codon_coord}}, and
\code{\link{base_coord}}.
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
