% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-methods.R
\name{[,AutomorphismList,ANY-method}
\alias{[,AutomorphismList,ANY-method}
\alias{'['}
\alias{extract}
\alias{extract-methods}
\alias{[,ListCodonMatrix,ANY-method}
\alias{[,MatrixSeq,ANY-method}
\alias{[[,AutomorphismList-method}
\alias{'[['}
\alias{[[,ListCodonMatrix-method}
\alias{$,AutomorphismList-method}
\alias{$}
\alias{names,ListCodonMatrix-method}
\alias{$,ListCodonMatrix-method}
\alias{$,MatrixSeq-method}
\alias{names<-,MatrixSeq-method}
\title{An S4 class to extract elements for objects created with
GenomAutomorphism package}
\usage{
\S4method{[}{AutomorphismList,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ListCodonMatrix,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{MatrixSeq,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{AutomorphismList}(x, i, j, ...)

\S4method{[[}{ListCodonMatrix}(x, i, j, ...)

\S4method{$}{AutomorphismList}(x, name)

\S4method{names}{ListCodonMatrix}(x)

\S4method{$}{ListCodonMatrix}(x, name)

\S4method{$}{MatrixSeq}(x, name)

\S4method{names}{MatrixSeq}(x) <- value
}
\arguments{
\item{x}{An object from \link{AutomorphismList}, \link{ListCodonMatrix}, or
\link{MatrixSeq}.}

\item{i, j, ...}{As in \code{\link[base]{Extract}}.}

\item{name}{Element name in the list 'x'.}

\item{value}{A character vector of up to the same length as x, or NULL.}
}
\value{
An object from \link{AutomorphismList}, \link{ListCodonMatrix}, or
\link{MatrixSeq} class.
}
\description{
First and second level subsetting of 'x'. Extraction using
names can be done as x$name.
}
\examples{
## Load automorphisms found BRCA1 primate genes
data("brca1_autm", package = "GenomAutomorphism")

## Extract AutomorphismList object with only one element
brca1_autm[1]

## Extract Automorphism object with only one element
brca1_autm[[3]]

## Extract Automorphism object using element name.
brca1_autm[["human_1.gorilla_1"]]
}
\author{
Robersy Sanchez \url{https://genomaths.com}

Robersy Sanchez (\url{https://genomaths.com}).
}
\keyword{internal}
