% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna_phychem.R
\name{dna_phychem}
\alias{dna_phychem}
\alias{dna_phychem,character-method}
\alias{dna_phychem,DNAStringSet_OR_DNAMultipleAlignment-method}
\title{DNA numerical matrix}
\usage{
dna_phychem(seqs, ...)

\S4method{dna_phychem}{character}(
  seqs,
  phychem = list(A = NULL, T = NULL, C = NULL, G = NULL, N = NULL)
)

\S4method{dna_phychem}{DNAStringSet_OR_DNAMultipleAlignment}(
  seqs,
  phychem = list(A = NULL, T = NULL, C = NULL, G = NULL, N = NULL),
  index_name = NULL,
  ...
)
}
\arguments{
\item{seqs}{A character string, a \code{\link[Biostrings]{DNAStringSet}}
or a \code{\link[Biostrings]{DNAMultipleAlignment}} class object carrying
the DNA pairwise alignment of two sequences.}

\item{...}{Not in use.}

\item{phychem}{A list of DNA bases physicochemical properties, e.g., like
those provided in \link{dna_phyche}.}

\item{index_name}{Optional. Name of breve description of the base
physicochemical property applied to represent the DNA sequence.}
}
\value{
A \link{MatrixSeq}-class object.
}
\description{
This function applies the numerical indices representing various
physicochemical and biochemical properties of DNA bases. As results, DNA
sequences are represented as numerical vectors which can be subject of
further downstream statistical analysis and digital signal processing.
}
\examples{
## Let's create DNAStringSet-class object 
base <- DNAStringSet(x = c( seq1 ='ACGTGATCAAGT', 
                            seq2 = 'GTGTGATCCAGT', 
                            seq3 = 'TCCTGATCAGGT'))


dna_phychem(seqs = base,
            phychem = list('A' = 0.87, 'C' = 0.88, 'T' = 0.82,
                            'G' = 0.89, 'N' = NA),
            index_name = "Proton-Affinity")

}
\seealso{
\link{peptide_phychem_index}
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
