% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_dist.R
\name{codon_dist}
\alias{codon_dist}
\alias{codon_dist,DNAStringSet-method}
\alias{codon_dist,character-method}
\alias{codon_dist,CodonGroup_OR_Automorphisms-method}
\title{Weighted Manhattan Distance Between Codons}
\usage{
codon_dist(x, y, ...)

\S4method{codon_dist}{DNAStringSet}(
  x,
  weight = NULL,
  group = c("Z4", "Z5"),
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  num.cores = 1L,
  tasks = 0L,
  verbose = FALSE
)

\S4method{codon_dist}{character}(
  x,
  y,
  weight = NULL,
  group = c("Z4", "Z5"),
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  num.cores = 1L,
  tasks = 0L,
  verbose = FALSE
)

\S4method{codon_dist}{CodonGroup_OR_Automorphisms}(
  x,
  weight = NULL,
  group = c("Z4", "Z5"),
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  num.cores = 1L,
  tasks = 0L,
  verbose = FALSE
)
}
\arguments{
\item{x, y}{A character string of codon sequences, i.e., sequences of DNA
base-triplets. If only 'x' argument is given, then it must be a
\code{\link[Biostrings]{DNAStringSet-class}} object.}

\item{...}{Not in use yet.}

\item{weight}{A numerical vector of  weights to compute weighted Manhattan
distance between codons. If \eqn{weight = NULL}, then
\eqn{weight = (1/4,1,1/16)} for \eqn{group = "Z4"} and
\eqn{weight = (1/5,1,1/25)} for \eqn{group = "Z5"}.}

\item{group}{A character string denoting the group representation for the
given codon sequence as shown in reference (2-3).}

\item{cube}{A character string denoting one of the 24 Genetic-code cubes,
as given in references (2-3).}

\item{num.cores, tasks}{Parameters for parallel computation using package
\code{\link[BiocParallel]{BiocParallel-package}}: the number of cores to
use, i.e. at most how many child processes will be run simultaneously (see
\code{\link[BiocParallel]{bplapply}} and the number of tasks per job (only
for Linux OS).}

\item{verbose}{If TRUE, prints the progress bar.}
}
\value{
A numerical vector with the pairwise distances between codons in
sequences 'x' and 'y'.
}
\description{
This function computes the weighted Manhattan distance between
codons from two sequences as given in reference (1). That is, given two
codons \eqn{x} and \eqn{y} with coordinates on the set of integers modulo 5
("Z5"): \eqn{x = (x_1, x_2, x_3)} and  \eqn{x = (y_1, y_2, y_3)} (see (1)),
the Weighted Manhattan distance between this two codons is defined as:

\deqn{d_w(x,y) = |x_1 - y_1|/5 + |x_2 - y_2| + |x_3 -y_3|/25}

If the codon coordinates are given on "Z4", then the Weighted Manhattan
distance is define as:

\deqn{d_w(x,y) = |x_1 - y_1|/4 + |x_2 - y_2| + |x_3 -y_3|/16}

Herein, we move to the generalized version given in reference (3), for
which:

\deqn{d_w(x,y) = |x_1 - y_1| w_1  + |x_2 - y_2| w_2 + |x_3 -y_3| w_3}

where we use the vector of \eqn{weight = (w_1, w_2, w_3)}.
}
\examples{
## Let's write two small DNA sequences
x = "ACGCGTGTACCGTGACTG"
y = "TGCGCCCGTGACGCGTGA"

codon_dist(x, y, group = "Z5")

## Alternatively, data can be vectors of codons, i.e., vectors of DNA 
## base-triplets (including gaps simbol "-").
x = c("ACG","CGT","GTA","CCG","TGA","CTG","ACG")
y = c("TGC","GCC","CGT","GAC","---","TGA","A-G")

## Gaps are not defined on "Z4"
codon_dist(x, y, group = "Z4")

## Gaps are considered on "Z5"
codon_dist(x, y, group = "Z5")

## Load an Automorphism-class object
data("autm", package = "GenomAutomorphism")
codon_dist(x = head(autm,20), group = "Z4")

## Load a pairwise alignment
data("aln", package = "GenomAutomorphism")
aln

codon_dist(x = aln, group = "Z5")

}
\references{
\enumerate{
\item Sanchez R. Evolutionary Analysis of DNA-Protein-Coding Regions Based
on a Genetic Code Cube Metric. Curr Top Med Chem. 2014;14: 407–417.
\url{https://doi.org/10.2174/1568026613666131204110022}.
\item M. V Jose, E.R. Morgado, R. Sanchez, T. Govezensky, The 24 possible
algebraic representations of the standard genetic code in six or in three
dimensions, Adv. Stud. Biol. 4 (2012) 119-152.\href{https://is.gd/na9eap}{PDF}.
\item R. Sanchez. Symmetric Group of the Genetic-Code Cubes. Effect of the
Genetic-Code Architecture on the Evolutionary Process MATCH Commun. Math.
Comput. Chem. 79 (2018) 527-560. \href{https://is.gd/ZY1Gx8}{PDF}.
}
}
\seealso{
\code{\link{codon_dist_matrix}}, \code{\link{automorphisms}},
\code{\link{codon_coord}}, and \code{\link{aminoacid_dist}}.
}
