% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base2codon.R
\name{base2codon}
\alias{base2codon}
\alias{base2codon,character-method}
\alias{base2codon,DNAStringSet-method}
\alias{base2codon,DNAMultipleAlignment-method}
\title{Split a DNA sequence into codons}
\usage{
base2codon(x, ...)

\S4method{base2codon}{character}(x)

\S4method{base2codon}{DNAStringSet}(x)

\S4method{base2codon}{DNAMultipleAlignment}(x)
}
\arguments{
\item{x}{A character string, \code{\link[Biostrings]{DNAStringSet-class}}
or \code{\link[Biostrings]{DNAMultipleAlignment-class}} object carrying the
a DNA sequence.}

\item{...}{Not in use.}
}
\value{
If the argument of 'x' is character string, then a character vector
of codons will returned. If the argument of 'x' is
\code{\link[Biostrings]{DNAStringSet-class}} or
\code{\link[Biostrings]{DNAMultipleAlignment-class}} object, then a matrix
of codons is returned.
}
\description{
This function split a DNA sequence into a codon sequence.
}
\details{
It is expected that the provided DNA sequence is multiple of
3, otherwise gaps are added to the end of the sequence.
}
\examples{

## Gaps are added at the sequence end.
seq <- c("ACCT")
base2codon(x = seq)

## This DNA sequence is multiple of 3
seq <- c("ACCTCA")
base2codon(x = seq)

## Load a DNAStringSet. A matrix of codons is returned
data("aln", package = "GenomAutomorphism")
base2codon(x = aln)

}
\author{
Robersy Sanchez \url{https://genomaths.com}. 01/15/2022
}
