% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automorphism_bycoef.R
\name{automorphism_bycoef}
\alias{automorphism_bycoef}
\alias{automorphism_bycoef,Automorphism-method}
\alias{automorphism_bycoef,AutomorphismList-method}
\title{Autmorphism Grouping by Coefficient}
\usage{
automorphism_bycoef(x, ...)

\S4method{automorphism_bycoef}{Automorphism}(x, mut.type = TRUE)

\S4method{automorphism_bycoef}{AutomorphismList}(
  x,
  min.len = 1L,
  mut.type = TRUE,
  num.cores = multicoreWorkers(),
  tasks = 0L,
  verbose = TRUE
)
}
\arguments{
\item{x}{An automorphism-class object returned by function
\code{\link{automorphisms}}.}

\item{...}{Not in use.}

\item{mut.type}{Logical. Whether to include the mutation type as given by
function \code{\link{mut_type}}.}

\item{min.len}{Minimum length of a range to be reported.}

\item{num.cores, tasks}{Integers. Argument \emph{num.cores} denotes the
number of cores to use, i.e. at most how many child processes will be run
simultaneously (see \code{\link[BiocParallel]{bplapply}} function from
BiocParallel package). Argument \emph{tasks} denotes the number of tasks
per job. value must be a scalar integer >= 0L. In this documentation a job
is defined as a single call to a function, such as
\code{\link[BiocParallel]{bplapply}}. A task is the division of the \eqn{X}
argument into chunks. When tasks == 0 (default), \eqn{X} is divided as
evenly as possible over the number of workers (see
\code{\link[BiocParallel]{MulticoreParam}} from BiocParallel package).}

\item{verbose}{logic(1). If TRUE, enable progress bar.}
}
\value{
An \code{\link{AutomorphismByCoef}} class object. A coefficient
with 0 value is assigned to mutational events that are not automorphisms,
e.g., indel mutations.
}
\description{
Automorphisms with the same automorphism's coefficients are
grouped.
}
\examples{
## Load dataset
data("autm", package = "GenomAutomorphism")

automorphism_bycoef(x = autm[1:2])

}
\seealso{
\code{\link{automorphisms}}
}
