% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autZ5.R
\name{autZ5}
\alias{autZ5}
\title{Compute the Automorphisms of Mutational Events Between two Codon
Sequences Represented in Z5.}
\usage{
autZ5(
  seq = NULL,
  filepath = NULL,
  cube = c("ACGT", "TGCA"),
  cube_alt = c("CATG", "GTAC"),
  start = NA,
  end = NA,
  chr = 1L,
  strand = "+",
  num.cores = multicoreWorkers(),
  tasks = 0L,
  verbose = TRUE
)
}
\arguments{
\item{seq}{An object from a \code{\link[Biostrings]{DNAStringSet}} or
\code{\link[Biostrings]{DNAMultipleAlignment}} class carrying the DNA
pairwise alignment of two sequences.}

\item{filepath}{A character vector containing the path to a file in
\emph{\strong{fasta}} format to be read. This argument must be given if
\emph{codon & base} arguments are not provided.}

\item{cube, cube_alt}{A character string denoting pairs of the 24
Genetic-code cubes, as given in references (2-3). That is, the base pairs
from the given cubes must be complementary each other. Such a cube pair are
call dual cubes and, as shown in reference (3), each pair integrates group.}

\item{start, end, chr, strand}{Optional parameters required to build a
\code{\link[GenomicRanges]{GRanges-class}}. If not provided the default
values given for the function definition will be used.}

\item{num.cores, tasks}{Parameters for parallel computation using package
\code{\link[BiocParallel]{BiocParallel-package}}: the number of cores to
use, i.e. at most how many child processes will be run simultaneously (see
\code{\link[BiocParallel]{bplapply}} and the number of tasks per job (only
for Linux OS).}

\item{verbose}{If TRUE, prints the progress bar.}
}
\value{
An object \code{\link{Automorphism-class}} with four columns on its
metacolumn named: \emph{seq1}, \emph{seq2}, \emph{autm}, and \emph{cube}.
}
\description{
Given two codon sequences represented in the Z5 Abelian group,
this function computes the automorphisms describing codon mutational
events.
}
\details{
Automorphisms in Z5 are described as functions
\eqn{f(x) = k x mod 64}, where k and x are elements from the set of
integers modulo 64. As noticed in reference (1). The pairwise alignment
provided in argument \emph{\strong{seq}} or the 'fasta' file
\emph{\strong{filepath}} must correspond to DNA base sequences.
}
\examples{
## Load a pairwise alignment
data("aln", package = "GenomAutomorphism")
aln

## Automorphism on Z5
autms <- autZ5(seq = aln, verbose = FALSE)
autms

}
\references{
\enumerate{
\item Sanchez R, Morgado E, Grau R. Gene algebra from a genetic code
algebraic structure. J Math Biol. 2005 Oct;51(4):431-57.
doi: 10.1007/s00285-005-0332-8. Epub 2005 Jul 13. PMID: 16012800. (
\href{https://arxiv.org/pdf/q-bio/0412033.pdf}{PDF}).
\item Robersy Sanchez, Jesus Barreto (2021) Genomic Abelian Finite
Groups.
\href{https://doi.org/10.1101/2021.06.01.446543}{doi:10.1101/2021.06.01.446543}
\item M. V Jose, E.R. Morgado, R. Sanchez, T. Govezensky, The 24 possible
algebraic representations of the standard genetic code in six or in three
dimensions, Adv. Stud. Biol. 4 (2012) 110-152.\href{https://is.gd/na9eap}{PDF}.
\item R. Sanchez. Symmetric Group of the Genetic-Code Cubes. Effect of the
Genetic-Code Architecture on the Evolutionary Process MATCH Commun. Math.
Comput. Chem. 79 (2018) 527-560. \href{https://bit.ly/2Z9mjM7}{PDF}
}
}
\seealso{
\code{\link{automorphisms}}
}
