% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.AutomorphismList.R
\name{as.AutomorphismList}
\alias{as.AutomorphismList}
\alias{as.AutomorphismList,GRangesList,GRanges_OR_NULL-method}
\alias{as.AutomorphismList,list,GRanges_OR_NULL-method}
\title{Methods for AutomorphismList-class Objects}
\usage{
as.AutomorphismList(x, grs = GRanges(), ...)

\S4method{as.AutomorphismList}{GRangesList,GRanges_OR_NULL}(x, grs = GRanges(), ...)

\S4method{as.AutomorphismList}{list,GRanges_OR_NULL}(x, grs = GRanges(), ...)
}
\arguments{
\item{x}{A \code{\link[S4Vectors]{DataFrame}} or a
\code{\link{automorphisms}} class object.}

\item{grs}{A \code{\link[GenomicRanges]{GRanges-class}} object.}

\item{...}{Not in use yet.}
}
\value{
The returned an AutomorphismList-class object.
}
\description{
Several methods are available to be applied on
\code{\link{Automorphism-class}} and \code{\link{AutomorphismList-class}}
objects.
}
\examples{
## Load a dataset
data("brca1_autm", package = "GenomAutomorphism")

## Let's transforming into a list of Automorphisms-class objects
x1 <- as.list(brca1_autm[seq(2)])

## Now, object 'x1' is transformed into a AutomorphismList-class object
as.AutomorphismList(x1)

## Alternatively, let's transform the list 'x1' into a GRangesList-class 
## object.
x1 <- GRangesList(x1)

## Next, object 'x1' is transformed into a AutomorphismList-class object
as.AutomorphismList(x1)
}
\seealso{
\code{\link{automorphism_bycoef}}, \code{\link{automorphisms}}
}
