% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_aaindex1.R
\docType{data}
\name{aaindex1}
\alias{aaindex1}
\title{List of 571 Amino Acid Physicochemical Indexes from AAindex Database}
\format{
A list carrying the the description 566 Amino Acid Indices in
AAindex ver.9.2 and the text file with the matrices imported from
\url{https://www.genome.jp/aaindex/}.
}
\usage{
data("aaindex1", package = "GenomAutomorphism")
}
\description{
The aminoacid indexes from Amino Acid Index Database
\url{https://www.genome.jp/aaindex/} are provided here. AAindex (ver.9.2)
is a database of numerical indices representing various physicochemical and
biochemical properties of amino acids and pairs of amino acids.
}
\examples{
## Load the mutation matrices from database from the packages
data("aaindex1", package = "GenomAutomorphism", envir = environment())

## Get the available aminoacid indices.
mat <- aa_phychem_index(aaindex = "aaindex1", acc_list = TRUE)
mat[1:10]

}
\seealso{
\link{aaindex2} and \link{aaindex3}.
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
\keyword{datasets}
