% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_phychem_index.R
\name{aa_phychem_index}
\alias{aa_phychem_index}
\alias{aa_mutmat}
\alias{aa_index}
\title{Amino acid mutation matrix}
\usage{
aa_phychem_index(acc = NA, aaindex = NA, acc_list = FALSE, info = FALSE)

aa_mutmat(acc = NA, aaindex = c("aaindex2", "aaindex3"), acc_list = FALSE)

aa_index(acc = NA, acc_list = FALSE, info = FALSE)
}
\arguments{
\item{acc}{Accession id for a specified mutation or contact potential
matrix.}

\item{aaindex}{Database where the requested accession id is locate. The
possible values are:  "aaindex2" or "aaindex3".}

\item{acc_list}{Logical. If TRUE, then the list of available matrices ids
and index names is returned.}

\item{info}{Logical. if TRUE, then whole information for the
physicochemical index will be returned.}
}
\value{
Depending on the user specifications, a mutation or contact
potential matrix, a list of available matrices (indices) ids or index
names can be returned. More specifically:

\describe{
\item{\strong{aa_mutmat}: }{Returns an aminoacid mutation matrix or
a statistical protein contact potentials matrix.}
\item{\strong{aa_index}: }{Returns the specified aminoacid physicochemical
indices.}
}
}
\description{
The aminoacid similarity matrices from Amino Acid Index Database
\url{https://www.genome.jp/aaindex/} are provided here.
\href{https://www.genome.jp/aaindex/}{AAindex} (ver.9.2) is a database of
numerical indices representing various physicochemical and biochemical
properties of amino acids and pairs of amino acids.

The similarity of amino acids can be represented numerically, expressed in
terms of observed mutation rate or physicochemical properties. A similarity
matrix, also called a mutation matrix, is a set of 210 numerical values, 20
diagonal and 20x19/2 off-diagonal elements, used for sequence alignments
and similarity searches.

Function \strong{\emph{aa_phychem_index}} is wrapper function to call two
other functions: \strong{\emph{aa_mutmat}} and \strong{\emph{aa_index}}
}
\examples{
## Load the mutation matrices from database from the packages
data("aaindex1","aaindex2", package = "GenomAutomorphism" )

## Get the available mutation matrices
mat <- aa_mutmat(aaindex = "aaindex2", acc_list = TRUE)
mat[seq(10)]

## Return the 'Base-substitution-protein-stability matrix 
## (Miyazawa-Jernigan, 1993)'
aa_mutmat(acc = "MIYS930101", aaindex = "aaindex2")

## Return the 'BLOSUM80 substitution matrix (Henikoff-Henikoff, 1992)'
aa_mutmat(acc = "HENS920103", aaindex = "aaindex2")

## Using wrapping function
aa_phychem_index(acc = "EISD840101", aaindex = "aaindex1")

## Just the info. The information provided after the reference
## corresponds to the correlaiton of 'EISD840101' with other indices.
aa_phychem_index(acc = "EISD840101", aaindex = "aaindex1", info = TRUE)

}
\seealso{
\link{aaindex1}, \link{aaindex2},  \link{aaindex3}, and \link{get_mutscore}.
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
