% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{AutomorphismByCoef-class}
\alias{AutomorphismByCoef-class}
\alias{AutomorphismByCoef}
\title{A class definition to store conserved gene/genomic regions found
in a MSA.}
\value{
AutomorphismByCoef-class definition.
}
\description{
Objects from this class are generated by function
\code{\link{automorphism_bycoef}}.
}
\section{AutomorphismByCoefList-class methods}{

\subsection{unlist(x):}{

It transforms a AutomorphismByCoefList-class object into an
AutomorphismByCoef-class object.
}

\subsection{as(x, "AutomorphismByCoefList")}{

It transforms a 'list' of AutomorphismByCoef-class object into an
AutomorphismByCoefList-class object.
}
}

\examples{
## Let's transform a AutomorphismByCoefList-class object into an 
## AutomorphismByCoef-class object
data("autby_coef")
unlist(autby_coef[1:2])

## Herein a 'list' object of AutomorphismByCoef-class objects
lista <- list(human = autby_coef[[1]], gorilla = autby_coef[[2]])

## Let's transform the the last list 'lista' into an
## AutomorphismByCoefList-class object
aut <- as(lista, "AutomorphismByCoefList")
aut

## Let's get the element names from object 'aut'
names(aut)

## Let's assign new names
names(aut) <- c("human_1", "gorilla_1")
names(aut)
}
\seealso{
\code{\link{automorphism_bycoef}}

\code{\link{AutomorphismByCoefList-class}} and
\code{\link{Automorphism-class}}
}
\keyword{internal}
