% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{Automorphism-class}
\alias{Automorphism-class}
\alias{Automorphism}
\alias{DataFrame_OR_data.frame-class}
\title{A class definition to store codon automorphisms in a given Abelian
group representation.}
\value{
Given the slot values, it defines an Automorphism-class object.
}
\description{
Two classes are involved in to storing codon automorphisms:
\emph{\strong{Automorphism-class}} and
\emph{\strong{AutomorphismList-class}}.
}
\details{
An \emph{\strong{Automorphism-class}} object has six
columns: "seq1", "seq2","coord1", "coord2", "autm", and "cube". See the
examples for function \code{\link{automorphisms}}. Observe that as the
\emph{\strong{Automorphism-class}} inherits from
\code{\link[GenomicRanges]{GRanges-class}} the transformation starting
from a \code{\link[GenomicRanges]{GRanges-class}} object into an
\emph{\strong{Automorphism-class}} is straightforward.

However, the transformation starting from a \code{\link[base]{data.frame}}
or a \code{\link[S4Vectors]{DataFrame-class}} object \eqn{"x"} requires for
the creation of an additional \code{\link[GenomicRanges]{GRanges-class}}
object, which by default will have the argument seqnames = "1", strand =
"+", start/end = seq(row(x)), length = nrow(x). These details must be keep
in mind to prevent fundamental errors in the downstream analyses.
}
\section{Automorphism-class methods}{

\subsection{as(from, "Automorphism"):}{

Permits the transformation of a \code{\link[base]{data.frame}} or a
\code{\link[S4Vectors]{DataFrame-class}} object into
\emph{\strong{Automorphism-class}} object if the proper columns are
provided.

Methods from \code{\link[GenomicRanges]{GRanges-class}} can also be
applied.
}
}

\seealso{
\code{\link{AutomorphismByCoef-class}} and
\code{\link{AutomorphismList-class}}
}
\keyword{internal}
