% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_shaker.R
\name{shake_enrichrResult}
\alias{shake_enrichrResult}
\title{Convert the output of Enrichr}
\usage{
shake_enrichrResult(enrichr_output_file, enrichr_output = NULL)
}
\arguments{
\item{enrichr_output_file}{The location of the text file output, as exported from
Enrichr}

\item{enrichr_output}{A data.frame with the output of \code{enrichr}, related to a
specific set of genesets. Usually it is one of the members of the list returned
by the initial call to \code{enrichr}.}
}
\value{
A \code{data.frame} compatible for use in \code{\link[=GeneTonic]{GeneTonic()}} as \code{res_enrich}
}
\description{
Convert the output of Enrichr for straightforward use in \code{\link[=GeneTonic]{GeneTonic()}}
}
\examples{
# library("enrichR")
# dbs <- c("GO_Molecular_Function_2018",
#          "GO_Cellular_Component_2018",
#          "GO_Biological_Process_2018",
#          "KEGG_2019_Human",
#          "Reactome_2016",
#          "WikiPathways_2019_Human")
# degenes <- (mosdef::deresult_to_df(res_macrophage_IFNg_vs_naive, FDR = 0.01)$SYMBOL)
# if called directly within R...
# enrichr_output_macrophage <- enrichr(degenes, dbs)
# or alternatively, if downloaded from the website in tabular format
enrichr_output_file <- system.file("extdata",
  "enrichr_tblexport_IFNg_vs_naive.txt",
  package = "GeneTonic"
)
res_from_enrichr <- shake_enrichrResult(enrichr_output_file = enrichr_output_file)
# res_from_enrichr2 <- shake_enrichrResult(
#   enrichr_output = enrichr_output_macrophage[["GO_Biological_Process_2018"]])
}
\seealso{
Other shakers: 
\code{\link{shake_davidResult}()},
\code{\link{shake_enrichResult}()},
\code{\link{shake_fgseaResult}()},
\code{\link{shake_gprofilerResult}()},
\code{\link{shake_gsenrichResult}()},
\code{\link{shake_topGOtableResult}()}
}
\concept{shakers}
