% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_shaker.R
\name{shake_enrichResult}
\alias{shake_enrichResult}
\title{Convert an enrichResult object}
\usage{
shake_enrichResult(obj)
}
\arguments{
\item{obj}{An \code{enrichResult} object, obtained via \code{clusterProfiler} (or also
via \code{reactomePA})}
}
\value{
A \code{data.frame} compatible for use in \code{\link[=GeneTonic]{GeneTonic()}} as \code{res_enrich}
}
\description{
Convert an enrichResult object for straightforward use in \code{\link[=GeneTonic]{GeneTonic()}}
}
\details{
This function is able to handle the output of \code{clusterProfiler} and \code{reactomePA},
as they both return an object of class \code{enrichResult} - and this in turn
contains the information required to create correctly a \code{res_enrich} object.
}
\examples{
# dds
library("macrophage")
library("DESeq2")
data(gse)
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive
de_symbols_IFNg_vs_naive <- res_macrophage_IFNg_vs_naive[
  (!(is.na(res_macrophage_IFNg_vs_naive$padj))) &
    (res_macrophage_IFNg_vs_naive$padj <= 0.05), "SYMBOL"
]
bg_ids <- rowData(dds_macrophage)$SYMBOL[rowSums(counts(dds_macrophage)) > 0]
\dontrun{
library("clusterProfiler")
library("org.Hs.eg.db")
ego_IFNg_vs_naive <- enrichGO(
  gene = de_symbols_IFNg_vs_naive,
  universe = bg_ids,
  keyType = "SYMBOL",
  OrgDb = org.Hs.eg.db,
  ont = "BP",
  pAdjustMethod = "BH",
  pvalueCutoff = 0.01,
  qvalueCutoff = 0.05,
  readable = FALSE
)

res_enrich <- shake_enrichResult(ego_IFNg_vs_naive)
head(res_enrich)
}
}
\seealso{
Other shakers: 
\code{\link{shake_davidResult}()},
\code{\link{shake_enrichrResult}()},
\code{\link{shake_fgseaResult}()},
\code{\link{shake_gprofilerResult}()},
\code{\link{shake_gsenrichResult}()},
\code{\link{shake_topGOtableResult}()}
}
\concept{shakers}
