% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_for_iSEE.R
\name{export_for_iSEE}
\alias{export_for_iSEE}
\title{export_for_iSEE}
\usage{
export_for_iSEE(dds, res_de, gtl = NULL)
}
\arguments{
\item{dds}{A \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} object.}

\item{res_de}{A \code{\link[DESeq2:DESeqResults]{DESeq2::DESeqResults()}} object.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}
}
\value{
A \code{SummarizedExperiment} object, with raw counts, normalized counts, and
variance-stabilizing transformed counts in the assay slots; and with colData
and rowData extracted from the corresponding input parameters - mainly the
results for differential expression analysis.
}
\description{
Combine data from a typical DESeq2 run
}
\details{
Combines the DESeqDataSet input and DESeqResults into a SummarizedExperiment
object, which can be readily explored with iSEE.

A typical usage would be after running the DESeq2 pipeline and/or after exploring
the functional enrichment results with \code{\link[=GeneTonic]{GeneTonic()}}
}
\examples{
library("macrophage")
library("DESeq2")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# now everything is in place to launch the app
# dds_macrophage <- DESeq2::DESeq(dds_macrophage)
se_macrophage <- export_for_iSEE(dds_macrophage, res_de)
# iSEE(se_macrophage)
}
