% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_upset.R
\name{create_upsetdata}
\alias{create_upsetdata}
\title{Create a geneset upset dataset}
\usage{
create_upsetdata(res_enrich, use_ids = FALSE)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to see the
formatting requirements.}

\item{use_ids}{Logical - whether to use the \code{gs_id}entifiers as names, or the
values provided as \code{gs_description}. Defaults to FALSE, using the full
descriptions}
}
\value{
A data.frame to be used in \code{ComplexUpset::upset()}
}
\description{
Create a data frame that can be fed to the upset function
}
\examples{
# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)

create_upsetdata(res_enrich[1:20, ])
dim(create_upsetdata(res_enrich[1:20, ]))

create_upsetdata(res_enrich[1:5, ], use_ids = TRUE)
}
