% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverlapFunctions.R
\name{summariseExonTypes}
\alias{summariseExonTypes}
\title{Summarise exon biotypes to broader categories}
\usage{
summariseExonTypes(types)
}
\arguments{
\item{types}{vector of exon biotypes}
}
\value{
vector of broader exon biotypes
}
\description{
Summarise exon biotypes to broader categories
}
\examples{
gtfFile <- system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools")
DEXSeqGtfFile <- system.file("extdata","gencode.vM14.dexseq.gtf",
package = "GeneStructureTools")

gtf <- rtracklayer::import(gtfFile)
gtf <- UTR2UTR53(gtf)
DEXSeqGtf <- rtracklayer::import(DEXSeqGtfFile)

findDEXexonType("ENSMUSG00000032366.15:E028", DEXSeqGtf, gtf)

DEXSeqResultsFile <- system.file("extdata","dexseq_results_significant.txt",
package = "GeneStructureTools")
DEXSeqResults <- read.table(DEXSeqResultsFile, sep="\\t")

types <- findDEXexonType(rownames(DEXSeqResults), DEXSeqGtf, gtf)
summarisedTypes <- summariseExonTypes(types)
table(types, summarisedTypes)
}
\seealso{
Other DEXSeq processing methods: \code{\link{DEXSeqIdsToGeneIds}},
  \code{\link{findDEXexonType}}
}
\author{
Beth Signal
}
