% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AltSplicingJunctionSupported.R
\name{replaceJunction}
\alias{replaceJunction}
\title{Find transcripts containing/overlapping junctions and replace them with alternative junctions}
\usage{
replaceJunction(whippetDataSet, junctionPairs, exons, type = NA)
}
\arguments{
\item{whippetDataSet}{whippetDataSet generated from \code{readWhippetDataSet()}}

\item{junctionPairs}{GRanges object with alternative Whippet junctions.
Generated by findJunctionPairs()}

\item{exons}{GRanges object made from a GTF containing exon coordinates}

\item{type}{type of Whippet event (AA/AD/AF/AL).
Note only one event type should be processed at a time.}
}
\value{
GRanges object with transcripts containing alternative junctions.
}
\description{
Find transcripts containing/overlapping junctions and replace them with alternative junctions
}
\examples{
whippetFiles <- system.file("extdata","whippet/",
package = "GeneStructureTools")
wds <- readWhippetDataSet(whippetFiles)
wds <- filterWhippetEvents(wds)

gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
exons <- gtf[gtf$type=="exon"]
transcripts <- gtf[gtf$type=="transcript"]
g <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10

wds.altAce <- filterWhippetEvents(wds, eventTypes="AA")
jncPairs.altAce <- findJunctionPairs(wds.altAce, type="AA")
transcripts.altAce <- replaceJunction(wds.altAce, jncPairs.altAce, exons, type="AA")

wds.altDon <- filterWhippetEvents(wds, eventTypes="AD")
jncPairs.altDon <- findJunctionPairs(wds.altDon, type="AD")
transcripts.altDon <- replaceJunction(wds.altDon, jncPairs.altDon, exons, type="AD")

wds.altFirst <- filterWhippetEvents(wds, eventTypes="AF", psiDelta=0.2)
jncPairs.altFirst <- findJunctionPairs(wds.altFirst, type="AF")
transcripts.altFirst <- replaceJunction(wds.altFirst, jncPairs.altFirst, exons, type="AF")

wds.altLast <- filterWhippetEvents(wds, eventTypes="AL", psiDelta=0.2)
jncPairs.altLast <- findJunctionPairs(wds.altLast, type="AL")
transcripts.altLast <- replaceJunction(wds.altLast, jncPairs.altLast, exons, type="AL")
}
\seealso{
Other whippet splicing isoform creation: \code{\link{addIntronInTranscript}},
  \code{\link{findExonContainingTranscripts}},
  \code{\link{findIntronContainingTranscripts}},
  \code{\link{findJunctionPairs}},
  \code{\link{skipExonInTranscript}}
}
\author{
Beth Signal
}
