% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExonSkipping.R
\name{reorderExonNumbers}
\alias{reorderExonNumbers}
\title{Reorder the exon numbers in a gtf annotation}
\usage{
reorderExonNumbers(exons, by = "transcript_id")
}
\arguments{
\item{exons}{GRanges object made from a GTF with ONLY exon annotations
(no gene, transcript, CDS etc.)}

\item{by}{what column are the transcripts grouped by?}
}
\value{
The same input GRanges, but with exon numbers reordered.
}
\description{
Reorder the exon numbers in a gtf annotation
}
\examples{
gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
exons <- gtf[gtf$type=="exon"]
exons <- reorderExonNumbers(exons)
}
\seealso{
Other gtf manipulation: \code{\link{UTR2UTR53}},
  \code{\link{addBroadTypes}},
  \code{\link{exonsToTranscripts}},
  \code{\link{filterGtfOverlap}},
  \code{\link{removeDuplicateTranscripts}},
  \code{\link{removeSameExon}}
}
\author{
Beth Signal
}
