% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTranscripts.R
\name{orfDiff}
\alias{orfDiff}
\title{Evaluate changes to ORFs caused by alternative splicing}
\usage{
orfDiff(orfsX, orfsY, filterNMD = TRUE, geneSimilarity = TRUE,
  compareUTR = TRUE, compareBy = "gene", allORFs = NULL)
}
\arguments{
\item{orfsX}{orf information for 'normal' transcripts. Generated by getOrfs()}

\item{orfsY}{orf information for 'alternative' transcripts. Generated by getOrfs()}

\item{filterNMD}{filter orf information for transcripts not targeted by nmd first?}

\item{geneSimilarity}{compare orf to all orfs in gene?}

\item{compareUTR}{compare UTRs?}

\item{compareBy}{compare by 'transcript' isoforms or by 'gene' groups}

\item{allORFs}{orf information for all transcripts for novel sequence comparisons.
Generated by getOrfs()}
}
\value{
data.frame with orf changes
}
\description{
Evaluate changes to ORFs caused by alternative splicing
}
\examples{

whippetFiles <- system.file("extdata","whippet/",
package = "GeneStructureTools")
wds <- readWhippetDataSet(whippetFiles)
wds <- filterWhippetEvents(wds)

gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
exons <- gtf[gtf$type=="exon"]
transcripts <- gtf[gtf$type=="transcript"]
g <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10

orfsProteinCoding <- getOrfs(exons[exons$gene_name=="Prex2" &
exons$transcript_type=="protein_coding"], BSgenome = g)
orfsNMD <- getOrfs(exons[exons$gene_name=="Prex2" &
exons$transcript_type=="nonsense_mediated_decay"], BSgenome = g)
orfDiff(orfsProteinCoding, orfsNMD, filterNMD=FALSE)

wds.exonSkip <- filterWhippetEvents(wds, eventTypes="CE",psiDelta = 0.2)
exons.exonSkip <- findExonContainingTranscripts(wds.exonSkip, exons,
variableWidth=0, findIntrons=FALSE, transcripts)
ExonSkippingTranscripts <- skipExonInTranscript(exons.exonSkip, exons, whippetDataSet=wds.exonSkip)

orfsSkipped <- getOrfs(ExonSkippingTranscripts[ExonSkippingTranscripts$set=="skipped_exon"],
BSgenome = g)
orfsIncluded <- getOrfs(ExonSkippingTranscripts[ExonSkippingTranscripts$set=="included_exon"],
BSgenome = g)
orfDiff(orfsSkipped, orfsIncluded, filterNMD=FALSE)
}
\seealso{
Other transcript isoform comparisons: \code{\link{attrChangeAltSpliced}},
  \code{\link{transcriptChangeSummary}}
}
\author{
Beth Signal
}
