% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGvisTracks.R
\name{makeGeneModel}
\alias{makeGeneModel}
\title{Convert GRanges gene model to data.frame for visualisation with Gviz}
\usage{
makeGeneModel(transcript)
}
\arguments{
\item{transcript}{GRanges of gene model to be visualised}
}
\value{
data.frame of a gene model for visualisation
}
\description{
Convert GRanges gene model to data.frame for visualisation with Gviz
}
\examples{
gtf <- rtracklayer::import(system.file("extdata", "example_gtf.gtf",
package="GeneStructureTools"))
transcript <- gtf[gtf$type=="exon" & gtf$gene_name=="Neurl1a"]
geneModel <- makeGeneModel(transcript)
}
\seealso{
Other Gviz gene structure visualisation: \code{\link{annotateGeneModel}}
}
\author{
Beth Signal
}
