% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGvisTracks.R
\name{annotateGeneModel}
\alias{annotateGeneModel}
\title{Annotate a GRanges gene model with ORF boundries for visualisation with Gviz}
\usage{
annotateGeneModel(transcripts, orfs)
}
\arguments{
\item{transcripts}{GRanges of gene model to be visualised}

\item{orfs}{ORF predictions. Created by getORFs()}
}
\value{
data.frame of a gene model for visualisation
}
\description{
Annotate a GRanges gene model with ORF boundries for visualisation with Gviz
}
\examples{
gtf <- rtracklayer::import(system.file("extdata", "example_gtf.gtf",
package="GeneStructureTools"))
transcript <- gtf[gtf$type=="exon" & gtf$gene_name=="Neurl1a"]
g <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
# longest ORF for each transcripts
orfs <- getOrfs(transcript, BSgenome = g, returnLongestOnly = TRUE)
geneModelAnnotated <- annotateGeneModel(transcript, orfs)
}
\seealso{
Other Gviz gene structure visualisation: \code{\link{makeGeneModel}}
}
\author{
Beth Signal
}
