% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeneBreakAccessors.R
\docType{methods}
\name{recurrentGenes,CopyNumberBreakPointGenes-method}
\alias{recurrentGenes}
\alias{recurrentGenes,CopyNumberBreakPointGenes-method}
\title{Access Options recurrentGenes. This method returns a dataframe that contains genes that are recurrently affected across samples based on a FDR threshold.}
\usage{
\S4method{recurrentGenes}{CopyNumberBreakPointGenes}(object,
  fdr.threshold = 0.1, summarize = TRUE, order.column = "FDR")
}
\arguments{
\item{object}{Output of bpStats(): an object of class \code{CopyNumberBreakPointGenes}}

\item{fdr.threshold}{A numeric Genes with lower FDR are returned}

\item{summarize}{A logical to determine whether to only output a selection of columns}

\item{order.column}{Name of the column to sort output on}
}
\value{
data.frame with genes recurrently affected by breakpoints
}
\description{
Access Options recurrentGenes. This method returns a dataframe that contains genes that are recurrently affected across samples based on a FDR threshold.
}
\examples{
data( copynumber.data.chr20 )
data( ens.gene.ann.hg18 )
bp <- getBreakpoints( copynumber.data.chr20 )
bp <- bpFilter( bp )
bp <- addGeneAnnotation( bp, ens.gene.ann.hg18 )
bp <- bpGenes( bp )
bp <- bpStats( bp )

recurrentGenes( bp )
}

